<#ibiztemplate>
TARGET=PSDATAENTITY
</#ibiztemplate>
<#assign deCodeNameCamel = srfcaseformat(de.codeName,'l_u2lC')?cap_first>
<#comment>实体是否配置预置属性</#comment>
<#assign hasDEPrefield=false>
<#if de.getPSDEFieldByPDT('ORGID',true)?? || de.getPSDEFieldByPDT('ORGSECTORID',true)??  || de.getPSDEFieldByPDT('CREATEMAN',true)?? >
    <#assign hasDEPrefield=true>
</#if>
<#if de.getStorageMode()==1 || de.getStorageMode()==2 ||de.getStorageMode()==4||de.getStorageMode()==0>
<#comment>判断是否有1：N的主关系，用于填充外键值文本、附加数据</#comment>
<#assign hasMinorPSDERs=0>
<#if item.getMinorPSDERs?? && item.getMinorPSDERs()??>
    <#list item.getMinorPSDERs() as MinorPSDER>
        <#if MinorPSDER.getDERType() =='DER1N'  && (MinorPSDER.getMajorPSDataEntity().getStorageMode()==1||MinorPSDER.getMajorPSDataEntity().getStorageMode()==2||MinorPSDER.getMajorPSDataEntity().getStorageMode()==4) >
            <#list de.getAllPSDEFields() as defield>
                <#if defield.getPSDER1N?? && defield.getPSDER1N()?? && defield.getPSDER1N().name==MinorPSDER.name && (((defield.getDataType())!'')!='PICKUP')>
                    <#assign hasMinorPSDERs=hasMinorPSDERs+1>
                    <#break>
                </#if>
            </#list>
        </#if>
        <#break>
    </#list>
</#if>
package ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().getCodeName()?lower_case}.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().getCodeName()?lower_case}.domain.${de.getCodeName()};
import ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().getCodeName()?lower_case}.filter.${de.getCodeName()}SearchContext;
import ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().getCodeName()?lower_case}.service.I${de.getCodeName()}Service;

import ${pub.getPKGCodeName()}.util.helper.CachedBeanCopier;

<#comment>SQL存储-Mybatis</#comment>
<#if de.getStorageMode()==1>

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().getCodeName()?lower_case}.mapper.${item.getCodeName()}Mapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[${item.getLogicName()}] 服务对象接口实现
 */
@Slf4j
@Service("${item.getCodeName()}ServiceImpl")
public class ${item.getCodeName()}ServiceImpl extends ServiceImpl<${de.getCodeName()}Mapper, ${de.getCodeName()}> implements I${de.getCodeName()}Service {

    <#assign keyfield=de.getKeyPSDEField()>

    <#comment>引入关联依赖-从关系</#comment>
    <#if de.getMajorPSDERs()??>
        <#list de.getMajorPSDERs() as der>
            <#if der.getDERType() =='DER1N' && (der.getMinorPSDataEntity().getStorageMode()==1||der.getMinorPSDataEntity().getStorageMode()==2||der.getMinorPSDataEntity().getStorageMode()==4)>
                <#if !P.exists('DER1N',der.getMinorPSDataEntity().getCodeName())>
                    <#if der.getMinorPSDataEntity().getCodeName()==de.codeName>

    private ${pub.getPKGCodeName()}.core.${der.getMinorPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.service.I${der.getMinorPSDataEntity().getCodeName()}Service ${srfcaseformat(der.getMinorPSDataEntity().getCodeName(),'l_u2lC')}Service = this;
                    <#else>
    @Autowired
    @Lazy
    private ${pub.getPKGCodeName()}.core.${der.getMinorPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.service.I${der.getMinorPSDataEntity().getCodeName()}Service ${srfcaseformat(der.getMinorPSDataEntity().getCodeName(),'l_u2lC')}Service;
                    </#if>
                </#if>
            </#if>
        </#list>
    </#if>
    <#comment>引入关联依赖-主关系</#comment>
    <#if de.getMinorPSDERs()??>
        <#list de.getMinorPSDERs() as der>
            <#if der.getDERType() =='DER1N' && (der.getMajorPSDataEntity().getStorageMode()==1||der.getMajorPSDataEntity().getStorageMode()==2||der.getMajorPSDataEntity().getStorageMode()==4)>
                <#if !P.exists('DER1N',der.getMajorPSDataEntity().getCodeName())>
                    <#if der.getMajorPSDataEntity().getCodeName()==de.codeName>

    private ${pub.getPKGCodeName()}.core.${der.getMajorPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.service.I${der.getMajorPSDataEntity().getCodeName()}Service ${srfcaseformat(der.getMajorPSDataEntity().getCodeName(),'l_u2lC')}Service = this;
                    <#else>
    @Autowired
    @Lazy
    private ${pub.getPKGCodeName()}.core.${der.getMajorPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.service.I${der.getMajorPSDataEntity().getCodeName()}Service ${srfcaseformat(der.getMajorPSDataEntity().getCodeName(),'l_u2lC')}Service;
                    </#if>
                </#if>
            </#if>
        </#list>
    </#if>
    <#comment>引入处理逻辑</#comment>
    <#if de.getAllPSDEActions()??>
        <#list de.getAllPSDEActions() as deAction>
            <#comment>实体行为调用处理逻辑</#comment>
            <#if deAction.getActionType() =='DELOGIC' >
            <#assign deLogic=deAction.getPSDELogic()>
                <@importDELogic deLogic />
            </#if>
            <#comment>实体行为附加逻辑</#comment>
            <#if deAction.getPSDEActionLogics()??>
                <#list deAction.getPSDEActionLogics() as deActionLogic>
                    <#assign deLogic=deActionLogic.getPSDELogic()>
                    <@importDELogic deLogic />
                </#list>
            </#if>
        </#list>
    </#if>

    private int batchSize = 500;

    <#comment>输出实体行为</#comment>
    <#if item.getAllPSDEActions()??>
        <#list item.getAllPSDEActions() as deaction>
            <#if deaction.isEnableBackend()>
                <#if deaction.getRender()??>
${deaction.getRender().code}
                <#else>
                    <#if (deaction.getActionType()=='USERCUSTOM')>
    @Override
    @Transactional
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        //自定义代码
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }

                    <#elseif deaction.getActionType()=='DELOGIC'>
    @Override
    @Transactional
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        ${deaction.getPSDELogic().getCodeName()?lower_case}Logic.execute(et);
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
         return et ;
    }

                    <#elseif deaction.getCodeName()?lower_case == 'get'>
    @Override
    @Transactional
    public ${item.getCodeName()} get(${srfjavatype(keyfield.stdDataType)} key) {
        <#comment>附加数据逻辑-操作前</#comment>
        <@buildEntityParam deaction/>
        <@addGetActionBoforeLogic deaction/>
        ${item.getCodeName()} et = getById(key);
        if(et==null){
            et=new ${item.getCodeName()}();
            et.set${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(key);
        }
        else{
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2||MajorPSDER.getMinorPSDataEntity().getStorageMode()==4)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
                        <#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
            et.set${srfcaseformat(listcode,'l_u2lC')?cap_first}(${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.selectBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(key));
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
        }
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }

                    <#elseif deaction.getCodeName()?lower_case == "createbatch">
                    <#elseif deaction.getCodeName()?lower_case == "updatebatch">
                    <#elseif deaction.getCodeName()?lower_case == "removebatch">
                    <#elseif deaction.getCodeName()?lower_case == "savebatch">
                    <#elseif deaction.getCodeName()?lower_case == "create">
    @Override
    @Transactional
    public boolean create(${item.getCodeName()} et) {
        <#if hasMinorPSDERs gt 0>
        fillParentData(et);
        </#if>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        if(!this.retBool(this.baseMapper.insert(et)))
            return false;
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2||MajorPSDER.getMinorPSDataEntity().getStorageMode()==4)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
        ${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.saveBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(),et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}());
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
        <#comment>成功后get填充一次完整信息</#comment>
        CachedBeanCopier.copy(get(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}()),et);
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true;
    }

    @Override
    public void createBatch(List<${item.getCodeName()}> list) {
        <#if hasMinorPSDERs gt 0>
        list.forEach(item->fillParentData(item));
        </#if>
        <#comment>联合主键，走SaveOrUpdateBatch，防止因主键冲突导致后续数据无法保存</#comment>
        <#if item.getUnionKeyValuePSDEFields()??>
        this.saveOrUpdateBatch(list,batchSize);
        <#else>
        this.saveBatch(list,batchSize);
        </#if>
    }

                    <#elseif deaction.getCodeName()?lower_case == "update">
    @Override
    @Transactional
    public boolean update(${item.getCodeName()} et) {
        <#if hasMinorPSDERs gt 0>
        fillParentData(et);
        </#if>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        <#if de.getKeyPSDEField()??>
        if(!update(et,(Wrapper) et.getUpdateWrapper(true).eq("${keyfield.name?lower_case}",et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}())))
            return false;
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2||MajorPSDER.getMinorPSDataEntity().getStorageMode()==4)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
        ${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.saveBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(),et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}());
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
        <#comment>成功后get填充一次完整信息</#comment>
        CachedBeanCopier.copy(get(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}()),et);
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true;
        <#else>
        throw new RuntimeException("请检查[${de.getLogicName()}]实体是否存在主键属性");
        </#if>
    }

    @Override
    public void updateBatch(List<${item.getCodeName()}> list) {
        <#if hasMinorPSDERs gt 0>
        list.forEach(item->fillParentData(item));
        </#if>
        updateBatchById(list,batchSize);
    }

                    <#elseif deaction.getCodeName()?lower_case == "save">
    @Override
    @Transactional
    public boolean save(${item.getCodeName()} et) {
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        if(!saveOrUpdate(et))
            return false;
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true;
    }

    @Override
    @Transactional(
            rollbackFor = {Exception.class}
    )
    public boolean saveOrUpdate(${item.getCodeName()} et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    public boolean saveBatch(Collection<${item.getCodeName()}> list) {
        <#if hasMinorPSDERs gt 0>
        list.forEach(item->fillParentData(item));
        </#if>
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    public void saveBatch(List<${item.getCodeName()}> list) {
        <#if hasMinorPSDERs gt 0>
        list.forEach(item->fillParentData(item));
        </#if>
        saveOrUpdateBatch(list,batchSize);
    }

                    <#elseif deaction.getCodeName()?lower_case == "remove">
    @Override
    @Transactional
    public boolean remove(${srfjavatype(keyfield.stdDataType)} key) {
        <#comment>附加数据逻辑-操作前，通过key构造entity传入逻辑中</#comment>
        <@buildEntityParam deaction/>
        <@addBoforeLogic deaction/>
                                <#if de.getMajorPSDERs()??>
                                    <#list de.getMajorPSDERs() as der>
                                        <#if der.getDERType() =='DER1N' && der.isNestedRS() && der.getMinorPSDataEntity()?? &&  (der.getMinorPSDataEntity().getStorageMode()==1||der.getMinorPSDataEntity().getStorageMode()==2||der.getMinorPSDataEntity().getStorageMode()==4) >
                                        <#assign MajorDerField = der.getPSPickupDEField()>
                                        <#assign minorKeyField = der.getMinorPSDataEntity().getKeyPSDEField()>
        ${srfcaseformat(der.getMinorPSDataEntity().getCodeName(),'l_u2lC')}Service.removeBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(key) ;
                                        </#if>
                                    </#list>
                                </#if>
        boolean result=removeById(key);
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return result ;
    }

    @Override
    public void removeBatch(Collection<${srfjavatype(keyfield.stdDataType)}> idList) {
        removeByIds(idList);
    }

                    <#elseif deaction.getCodeName()?lower_case == "getdraft">
    @Override
    public ${item.getCodeName()} getDraft(${item.getCodeName()} et) {
        <#if hasMinorPSDERs gt 0>
        fillParentData(et);
        </#if>
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }

                    <#elseif deaction.getCodeName()?lower_case == "checkkey">
    @Override
    public boolean checkKey(${item.getCodeName()} et) {
        return (!ObjectUtils.isEmpty(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}()))&&(!Objects.isNull(this.getById(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}())));
    }

                    <#else>
    @Override
    @Transactional
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        //自定义代码
        return et;
    }

                    </#if>
                </#if>
            </#if>
        </#list>
    </#if>

    <#comment>1：N关系中，在子实体中创建父实体的实例对象</#comment>
	<#if de.getMinorPSDERs?? && de.getMinorPSDERs()??>
		<#list de.getMinorPSDERs() as MinorPSDER>
			<#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N'>
				<#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()??>
					<#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
					<#if MajorEntity.name?? && MinorPSDER.getCodeName()?? >
						<#if MinorPSDER.getPSPickupDEField?? && MinorPSDER.getPSPickupDEField()??>
							<#assign MajorkeyField = MajorEntity.getKeyPSDEField()>
							<#assign MajorField = MinorPSDER.getPSPickupDEField()>
							<#if de.getDefaultPSDEDataSet()??>
								<#assign deDefaultDataSet=de.getDefaultPSDEDataSet()>
								<#if deDefaultDataSet.getPSDEDataQueries()??>
	@Override
    public List<${item.getCodeName()}> selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case}) {
        return baseMapper.selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case});
    }

    @Override
    public void removeBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case}) {
        this.remove(new QueryWrapper<${item.getCodeName()}>().eq("${MajorField.getName()?lower_case}",${MajorkeyField.codeName?lower_case}));
    }

	                                <#assign nested=MinorPSDER.isNestedRS()>
                                    <#if nested == false && MinorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                                        <#list MinorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                            <#if api.isNested()>
                                                <#assign nested=true>
                                            </#if>
                                        </#list>
                                    </#if>
                                    <#if nested>
	@Override
    public void saveBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case},List<${item.getCodeName()}> list) {
        if(list==null)
            return;
        Set<${srfjavatype(keyfield.stdDataType)}> delIds=new HashSet<${srfjavatype(keyfield.stdDataType)}>();
        List<${item.getCodeName()}> _update=new ArrayList<${item.getCodeName()}>();
        List<${item.getCodeName()}> _create=new ArrayList<${item.getCodeName()}>();
        for(${item.getCodeName()} before:selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case})){
            delIds.add(before.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
        }
        for(${item.getCodeName()} sub:list) {
            sub.set${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case});
            if(ObjectUtils.isEmpty(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}()))
                sub.set${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}((${srfjavatype(keyfield.stdDataType)})sub.getDefaultKey(true));
            if(delIds.contains(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}())) {
                delIds.remove(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0)
            this.updateBatch(_update);
        if(_create.size()>0)
            this.createBatch(_create);
        if(delIds.size()>0)
            this.removeBatch(delIds);
	}

                                    </#if>
								</#if>
							</#if>
						</#if>
					</#if>
				</#if>
			</#if>
		</#list>
	</#if>

    <#comment>输出数据查询</#comment>
    <#if item.getAllPSDEDataSets()??>
        <#list item.getAllPSDEDataSets() as dedataset>
    /**
     * 查询集合 ${dedataset.getLogicName()}
     */
    @Override
    public Page<<#if dedataset.isEnableGroup()>HashMap<#else>${item.getCodeName()}</#if>> search${dedataset.getCodeName()}(${item.getCodeName()}SearchContext context) {
            <#if item.isEnableSQLStorage() && item.getAllPSDEDBTables()??>
                <#--<#list item.getAllPSDEDBTables() as detable>-->
        <#if de.hasPSDEWF()==true>
        fillWFTaskContext(context);
        </#if>
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<<#if dedataset.isEnableGroup()>HashMap<#else>${item.getCodeName()}</#if>> pages=baseMapper.search${dedataset.getCodeName()}(context.getPages(),context,context.getSelectCond());
        return new PageImpl<<#if dedataset.isEnableGroup()>HashMap<#else>${item.getCodeName()}</#if>>(pages.getRecords(), context.getPageable(), pages.getTotal());
                <#--</#list>-->
            <#else>
        return null ;
            </#if>
    }

        </#list>
    </#if>

    <#comment>引入工作流FeignClient</#comment>
    <#if de.hasPSDEWF()==true>
    <#assign entityName=srfpluralize(item.getCodeName()?lower_case)>
    @Autowired
    private ${pub.getPKGCodeName()}.util.client.IBZWFFeignClient ibzwfFeignClient;

    /**
     * 查询工作流待办
     * @param context
     */
    private void fillWFTaskContext(${item.getCodeName()}SearchContext context){

        if(!StringUtils.isEmpty(context.getUserTaskId()) && !StringUtils.isEmpty(context.getProcessDefinitionKey())){
            List<String> businessKeys= ibzwfFeignClient.getbusinesskeysByUserId("${sys.getCodeName()?lower_case}", ${pub.getPKGCodeName()}.util.security.AuthenticationUser.getAuthenticationUser().getUserid(),"${entityName}",context.getProcessDefinitionKey(),context.getUserTaskId());
            if(businessKeys.size()>0){
                context.getSelectCond().in("${keyfield.name?lower_case}",businessKeys);
            }
            else{
                context.getSelectCond().apply("1<>1");
            }
        }
    }
    </#if>

    <#comment>为当前实体填充父数据（外键值文本、外键值附加数据）</#comment>
    <#if hasMinorPSDERs gt 0>
    /**
     * 为当前实体填充父数据（外键值文本、外键值附加数据）
     * @param et
     */
    private void fillParentData(${item.getCodeName()} et){
        <#list item.getMinorPSDERs() as MinorPSDER>
            <#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N' && (MinorPSDER.getMajorPSDataEntity().getStorageMode()==1||MinorPSDER.getMajorPSDataEntity().getStorageMode()==2||MinorPSDER.getMajorPSDataEntity().getStorageMode()==4)>
                <#assign hasPickupData=false>
                <#list de.getAllPSDEFields() as defield>
                    <#if defield.getPSDER1N?? && defield.getPSDER1N()?? && defield.getPSDER1N().name==MinorPSDER.name && (((defield.getDataType())!'')!='PICKUP')>
                        <#assign hasPickupData=true>
                        <#break>
                    </#if>
                </#list>
                <#if hasPickupData==true && MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()?? && MinorPSDER.getCodeName?? && MinorPSDER.getCodeName()??>
                    <#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
                    <#assign MajorEntityName=srfcaseformat(MinorPSDER.getCodeName(),'l_u2lC')>
                    <#assign MajorKeyFieldCodeName =srfcaseformat(MinorPSDER.getPSPickupDEField().codeName,'l_u2lC')?cap_first>
                    <#assign MajorEntityService=srfcaseformat(MinorPSDER.getMajorPSDataEntity().getCodeName(),'l_u2lC')+"Service">
        //实体关系[${MinorPSDER.name}]
        if(!ObjectUtils.isEmpty(et.get${MajorKeyFieldCodeName}())){
            ${pub.getPKGCodeName()}.core.${MajorEntity.getPSSystemModule().getCodeName()?lower_case}.domain.${MajorEntity.getCodeName()} ${MajorEntityName}=et.get${MajorEntityName?cap_first}();
            if(ObjectUtils.isEmpty(${MajorEntityName})){
                ${pub.getPKGCodeName()}.core.${MajorEntity.getPSSystemModule().getCodeName()?lower_case}.domain.${MajorEntity.getCodeName()} majorEntity=${MajorEntityService}.get(et.get${MajorKeyFieldCodeName}());
                et.set${MajorEntityName?cap_first}(majorEntity);
                ${MajorEntityName}=majorEntity;
            }
            <#comment>找出当前关系的外键值文本及附加数据字段</#comment>
            <#list de.getAllPSDEFields() as defield>
                <#if defield.getPSDER1N?? && defield.getPSDER1N()?? && defield.getPSDER1N().name==MinorPSDER.name && (((defield.getDataType())!'')!='PICKUP')>
                    <#assign minorFieldCodeName = srfcaseformat(defield.getCodeName(),'l_u2lC')?cap_first >
                    <#assign majorFieldCodeName = srfcaseformat(defield.getRelatedPSDEField().getCodeName(),'l_u2lC')?cap_first >
            et.set${minorFieldCodeName}(${MajorEntityName}.get${majorFieldCodeName}());
                </#if>
            </#list>
        }
                </#if>
            </#if>
        </#list>
    }
    </#if>

    <#comment>输出自定义sql查询</#comment>
    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

    <#if hasDEPrefield>
    @Override
    public List<${de.codeName}> get${deCodeNameCamel}ByIds(List<String> ids) {
         return this.listByIds(ids);
    }

    @Override
    public List<${de.codeName}> get${deCodeNameCamel}ByEntities(List<${de.codeName}> entities) {
        List ids =new ArrayList();
        for(${de.codeName} entity : entities){
            Serializable id=entity.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}();
            if(!ObjectUtils.isEmpty(id)){
                ids.add(id);
            }
        }
        if(ids.size()>0)
           return this.listByIds(ids);
        else
           return entities;
    }
    </#if>

}

<#comment>NOSQL存储</#comment>
<#elseif de.getStorageMode()==2>

import ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().codeName?lower_case}.repository.${de.codeName}Repository;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import javax.annotation.Resource;
import com.mongodb.QueryBuilder;
/**
 * 实体[${item.getLogicName()}] 服务对象接口实现
 */
@Slf4j
@Service
public class ${item.getCodeName()}ServiceImpl implements I${de.getCodeName()}Service {

    @Autowired
    private ${item.getCodeName()}Repository repository;
    <#assign keyfield=de.getKeyPSDEField()>

    <#comment>引入关联依赖</#comment>
    <#if de.getMajorPSDERs()??>
        <#list de.getMajorPSDERs() as der>
            <#if der.getDERType() =='DER1N' && (der.getMinorPSDataEntity().getStorageMode()==1||der.getMinorPSDataEntity().getStorageMode()==2||der.getMinorPSDataEntity().getStorageMode()==4)>
                <#if !P.exists('DEMinorPSDataEntity',der.getMinorPSDataEntity().getCodeName())>
    @Autowired
    @Lazy
    private ${pub.getPKGCodeName()}.core.${der.getMinorPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.service.I${der.getMinorPSDataEntity().getCodeName()}Service ${srfcaseformat(der.getMinorPSDataEntity().getCodeName(),'l_u2lC')}Service;
                </#if>
            </#if>
        </#list>
    </#if>
    <#comment>引入处理逻辑</#comment>
    <#if de.getAllPSDEActions()??>
        <#list de.getAllPSDEActions() as deAction>
            <#comment>实体行为调用处理逻辑</#comment>
            <#if deAction.getActionType() =='DELOGIC' >
            <#assign deLogic=deAction.getPSDELogic()>
                <@importDELogic deLogic />
            </#if>
            <#comment>实体行为附加逻辑</#comment>
            <#if deAction.getPSDEActionLogics()??>
                <#list deAction.getPSDEActionLogics() as deActionLogic>
                    <#assign deLogic=deActionLogic.getPSDELogic()>
                    <@importDELogic deLogic />
                </#list>
            </#if>
        </#list>
    </#if>

    <#comment>输出实体行为</#comment>
    <#if item.getAllPSDEActions()??>
        <#list item.getAllPSDEActions() as deaction>
            <#if deaction.isEnableBackend()>
                <#if deaction.getRender()??>
${deaction.getRender().code}
                <#else>
                    <#if (deaction.getActionType()=='USERCUSTOM')>
    @Override
    @Transactional
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        //自定义代码
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }

                    <#elseif deaction.getActionType()=='DELOGIC'>
    @Override
    @Transactional
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
         <#comment>附加数据逻辑-操作前</#comment>
         <@addBoforeLogic deaction/>
         ${deaction.getPSDELogic().getCodeName()?lower_case}Logic.execute(et);
         <#comment>附加数据逻辑-操作后</#comment>
         <@addAfterLogic deaction/>
         return et ;
    }

                    <#elseif deaction.getCodeName()?lower_case == 'get'>
    @Override
    @Transactional
    public ${item.getCodeName()} get(${srfjavatype(keyfield.stdDataType)} key) {
        <@buildEntityParam deaction/>
        <@addGetActionBoforeLogic deaction/>
        Optional<${item.getCodeName()}> result = repository.findById(key);
        if(!result.isPresent()){
            ${item.getCodeName()} et=new ${item.getCodeName()}();
            et.set${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(key);
            <@addAfterLogic deaction/>
            return et;
        }
        else{
            ${item.getCodeName()} et=result.get();
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2||MajorPSDER.getMinorPSDataEntity().getStorageMode()==4)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
            et.set${srfcaseformat(listcode,'l_u2lC')?cap_first}(${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.selectBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(key));
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
            <@addAfterLogic deaction/>
            return et;
        }
    }

                    <#elseif deaction.getCodeName()?lower_case == "createbatch">
                    <#elseif deaction.getCodeName()?lower_case == "updatebatch">
                    <#elseif deaction.getCodeName()?lower_case == "removebatch">
                    <#elseif deaction.getCodeName()?lower_case == "savebatch">
                    <#elseif deaction.getCodeName()?lower_case == "create">
    @Override
    @Transactional
    public boolean create(${item.getCodeName()} et) {
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        repository.insert(et);
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2||MajorPSDER.getMinorPSDataEntity().getStorageMode()==4)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
        ${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.saveBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(),et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}());
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
        <#comment>成功后get填充一次完整信息</#comment>
        CachedBeanCopier.copy(get(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}()),et);
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true ;
    }

    @Override
    public void createBatch(List<${item.getCodeName()}> list) {
        <#comment>联合主键，走SaveOrUpdateBatch，防止因主键冲突导致后续数据无法保存</#comment>
        <#if item.getUnionKeyValuePSDEFields()??>
        repository.saveAll(list);
        <#else>
        repository.insert(list);
        </#if>
    }

                    <#elseif deaction.getCodeName()?lower_case == "update">
    @Override
    @Transactional
    public boolean update(${item.getCodeName()} et) {
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        <#if de.getKeyPSDEField()??>
        repository.save(et);
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2||MajorPSDER.getMinorPSDataEntity().getStorageMode()==4)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
        ${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.saveBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(),et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}());
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
        <#comment>成功后get填充一次完整信息</#comment>
        CachedBeanCopier.copy(get(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}()),et);
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true ;
        <#else>
        throw new RuntimeException("请检查[${de.getLogicName()}]实体是否存在主键属性");
        </#if>
    }

    @Override
    public void updateBatch(List<${item.getCodeName()}> list) {
        repository.saveAll(list);
    }

                    <#elseif deaction.getCodeName()?lower_case == "save">
    @Override
    @Transactional
    public boolean save(${item.getCodeName()} et) {
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        <#if de.getKeyPSDEField()??>
        repository.save(et);
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2||MajorPSDER.getMinorPSDataEntity().getStorageMode()==4)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
        ${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.saveBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(),et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}());
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
        <#comment>成功后get填充一次完整信息</#comment>
        CachedBeanCopier.copy(get(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}()),et);
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true ;
        <#else>
        throw new RuntimeException("请检查[${de.getLogicName()}]实体是否存在主键属性");
        </#if>
    }


    @Override
    public void saveBatch(List<${item.getCodeName()}> list) {
        repository.saveAll(list);
    }

                    <#elseif deaction.getCodeName()?lower_case == "remove">
    @Override
    @Transactional
    public boolean remove(${srfjavatype(keyfield.stdDataType)} key) {
        <#comment>附加数据逻辑-操作前</#comment>
        <@buildEntityParam deaction/>
        <@addBoforeLogic deaction/>
                                <#if de.getMajorPSDERs()??>
                                    <#list de.getMajorPSDERs() as der>
                                        <#if der.getDERType() =='DER1N' && der.isNestedRS() && der.getMinorPSDataEntity()?? &&  (der.getMinorPSDataEntity().getStorageMode()==1||der.getMinorPSDataEntity().getStorageMode()==2||der.getMinorPSDataEntity().getStorageMode()==4) >
                                        <#assign MajorDerField = der.getPSPickupDEField()>
                                        <#assign minorKeyField = der.getMinorPSDataEntity().getKeyPSDEField()>
        ${srfcaseformat(der.getMinorPSDataEntity().getCodeName(),'l_u2lC')}Service.removeBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(key) ;
                                        </#if>
                                    </#list>
                                </#if>
        repository.deleteById(key);
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true ;
    }

    @Override
    public void removeBatch(Collection<${srfjavatype(keyfield.stdDataType)}> idList) {
        repository.deleteAll(repository.findAllById(idList));
    }

                    <#elseif deaction.getCodeName()?lower_case == "getdraft">
    @Override
    public ${item.getCodeName()} getDraft(${item.getCodeName()} et) {
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }

                    <#elseif deaction.getCodeName()?lower_case == "checkkey">
    @Override
    public boolean checkKey(${item.getCodeName()} et) {
        return repository.findById(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}()).isPresent();
    }

                    <#else>
    @Override
    @Transactional
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
        //自定义代码
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }

                    </#if>
                </#if>
            </#if>
        </#list>
    </#if>


    <#comment>1：N关系中，在子实体中创建父实体的实例对象</#comment>
	<#if de.getMinorPSDERs?? && de.getMinorPSDERs()??>
		<#list de.getMinorPSDERs() as MinorPSDER>
			<#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N'>
				<#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()??>
					<#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
					<#if MajorEntity.name?? && MinorPSDER.getCodeName()?? >
						<#if MinorPSDER.getPSPickupDEField?? && MinorPSDER.getPSPickupDEField()??>
							<#assign MajorkeyField = MajorEntity.getKeyPSDEField()>
							<#assign MajorField = MinorPSDER.getPSPickupDEField()>
							<#if de.getDefaultPSDEDataSet()??>
								<#assign deDefaultDataSet=de.getDefaultPSDEDataSet()>
								<#if deDefaultDataSet.getPSDEDataQueries()??>
	@Override
    public List<${item.getCodeName()}> selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case}) {
        ${item.getCodeName()}SearchContext context=new ${item.getCodeName()}SearchContext();
        context.setN_${MajorField.name?lower_case}_eq(${MajorkeyField.codeName?lower_case});
        Query query = new BasicQuery(context.getSelectCond().get().toString());
        return mongoTemplate.find(query,${item.getCodeName()}.class);
    }

    @Override
    public void removeBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case}) {
        Set<${srfjavatype(keyfield.stdDataType)}> delIds=new HashSet<${srfjavatype(keyfield.stdDataType)}>();
        for(${item.getCodeName()} before:selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case})){
            delIds.add(before.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
        }
        if(delIds.size()>0)
            this.removeBatch(delIds);
    }

	                                <#assign nested=MinorPSDER.isNestedRS()>
                                    <#if nested == false && MinorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                                        <#list MinorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                            <#if api.isNested()>
                                                <#assign nested=true>
                                            </#if>
                                        </#list>
                                    </#if>
                                    <#if nested>
	@Override
    public void saveBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case},List<${item.getCodeName()}> list) {
        if(list==null)
            return;
        Set<${srfjavatype(keyfield.stdDataType)}> delIds=new HashSet<${srfjavatype(keyfield.stdDataType)}>();
        List<${item.getCodeName()}> _update=new ArrayList<${item.getCodeName()}>();
        List<${item.getCodeName()}> _create=new ArrayList<${item.getCodeName()}>();
        for(${item.getCodeName()} before:selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case})){
            delIds.add(before.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
        }
        for(${item.getCodeName()} sub:list) {
            sub.set${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case});
            if(ObjectUtils.isEmpty(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}()))
                sub.set${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}((${srfjavatype(keyfield.stdDataType)})sub.getDefaultKey(true));
            if(delIds.contains(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}())) {
                delIds.remove(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0)
            this.updateBatch(_update);
        if(_create.size()>0)
            this.createBatch(_create);
        if(delIds.size()>0)
            this.removeBatch(delIds);
	}

                                    </#if>
								</#if>
							</#if>
						</#if>
					</#if>
				</#if>
			</#if>
		</#list>
	</#if>
    

    @Resource
    private MongoTemplate mongoTemplate;

    <#comment>输出数据查询</#comment>
    <#if item.getAllPSDEDataSets()??>
        <#list item.getAllPSDEDataSets() as dedataset>
    /**
     * 查询集合 ${dedataset.getLogicName()}
     */
    @Override
    public Page<${item.getCodeName()}> search${dedataset.getCodeName()}(${item.getCodeName()}SearchContext context) {
        Query query = new BasicQuery(context.getSelectCond().get().toString());
        long total = mongoTemplate.count(query, ${item.getCodeName()}.class);
        List<${item.getCodeName()}> list=mongoTemplate.find(query.with(context.getPageable()),${item.getCodeName()}.class);
        return new PageImpl<${item.getCodeName()}>(list,context.getPageable(),total);
    }

        </#list>
    </#if>

    <#if hasDEPrefield>
    @Override
    public List<${de.codeName}> get${deCodeNameCamel}ByIds(List<String> ids) {
        QueryBuilder permissionCond=new QueryBuilder();
        permissionCond.and("${keyfield.codeName?lower_case}").in(ids);
        Query query = new BasicQuery(permissionCond.get().toString());
        return mongoTemplate.find(query,${de.codeName}.class);
    }

    @Override
    public List<${de.codeName}> get${deCodeNameCamel}ByEntities(List<${de.codeName}> entities) {

        List ids =new ArrayList();
        for(${de.codeName} entity : entities){
            Serializable id=entity.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}();
            if(!ObjectUtils.isEmpty(id)){
                ids.add(id);
            }
        }
        if(ids.size()>0){
            QueryBuilder permissionCond=new QueryBuilder();
            permissionCond.and("${keyfield.codeName?lower_case}").in(ids);
            Query query = new BasicQuery(permissionCond.get().toString());
            return mongoTemplate.find(query,${de.codeName}.class);
        }
        else
            return entities;
    }
    </#if>

}


<#comment>Api存储</#comment>
<#elseif de.getStorageMode()==4>
<#assign subSysServiceApiDECodeName=item.getPSSubSysServiceAPIDE().codeName>

import ${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.client.${subSysServiceApiDECodeName}FeignClient;

/**
 * 实体[${item.getLogicName()}] 服务对象接口实现
 */
@Slf4j
@Service
public class ${item.getCodeName()}ServiceImpl implements I${de.getCodeName()}Service {

    <#comment>引入feignClient</#comment>
    @Autowired
    ${subSysServiceApiDECodeName}FeignClient ${subSysServiceApiDECodeName?uncap_first}FeignClient;

    <#assign keyfield=de.getKeyPSDEField()>

    <#comment>引入关联依赖</#comment>
    <#if de.getMajorPSDERs()??>
        <#list de.getMajorPSDERs() as der>
            <#if der.getDERType() =='DER1N' && (der.getMinorPSDataEntity().getStorageMode()==1||der.getMinorPSDataEntity().getStorageMode()==2)>
                <#if !P.exists('DEMinorPSDataEntity',der.getMinorPSDataEntity().getCodeName())>
    @Autowired
    @Lazy
    private ${pub.getPKGCodeName()}.core.${der.getMinorPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.service.I${der.getMinorPSDataEntity().getCodeName()}Service ${srfcaseformat(der.getMinorPSDataEntity().getCodeName(),'l_u2lC')}Service;
                </#if>
            </#if>
        </#list>
    </#if>

    <#comment>输出实体行为</#comment>
    <#if item.getAllPSDEActions()??>
        <#list item.getAllPSDEActions() as deaction>
            <#if deaction.isEnableBackend()>
                <#if deaction.getRender()??>
${deaction.getRender().code}
                <#else>
                    <#if (deaction.getActionType()=='USERCUSTOM')>
    @Override
    @Transactional
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        //自定义代码
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }

                    <#elseif deaction.getActionType()=='DELOGIC'>
    @Override
    @Transactional
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
         <#comment>附加数据逻辑-操作前</#comment>
         <@addBoforeLogic deaction/>
         ${deaction.getPSDELogic().getCodeName()?lower_case}Logic.execute(et);
         <#comment>附加数据逻辑-操作后</#comment>
         <@addAfterLogic deaction/>
         return et ;
    }

                    <#elseif deaction.getCodeName()?lower_case == 'get'>
    @Override
    public ${item.getCodeName()} get(${srfjavatype(keyfield.stdDataType)} ${keyfield.getCodeName()?lower_case}) {
                    <#if item.isEnableAPIStorage()>
                        <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
                            <#--<#comment>附加数据逻辑-操作前</#comment>-->
                            <#--<@buildEntityParam deaction/>-->
                            <#--<@addGetActionBoforeLogic deaction/>-->
		${item.getCodeName()} et=${subSysServiceApiDECodeName?uncap_first}FeignClient.${deaction.getPSSubSysServiceAPIDEMethod().getCodeName()?uncap_first}(${keyfield.getCodeName()?lower_case});
        if(et==null){
            et=new ${item.getCodeName()}();
            et.set${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(${keyfield.getCodeName()?lower_case});
        }
        else{
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
            et.set${srfcaseformat(listcode,'l_u2lC')?cap_first}(${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.selectBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(key));
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
        }
        <#--<#comment>附加数据逻辑-操作后</#comment>-->
        <#--<@addAfterLogic deaction/>-->
        return  et;
                        <#else>
        return null;
                        </#if>
                    </#if>
    }

                    <#elseif deaction.getCodeName()?lower_case == "createbatch">
                    <#elseif deaction.getCodeName()?lower_case == "updatebatch">
                    <#elseif deaction.getCodeName()?lower_case == "removebatch">
                    <#elseif deaction.getCodeName()?lower_case == "savebatch">
                    <#elseif deaction.getCodeName()?lower_case == "create">
    @Override
    public boolean create(${item.getCodeName()} et) {
                        <#if item.isEnableAPIStorage()>
                            <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
                                <#comment>附加数据逻辑-操作前</#comment>
                                <@addBoforeLogic deaction/>
        ${item.getCodeName()} rt = ${subSysServiceApiDECodeName?uncap_first}FeignClient.create(et);
        if(rt==null)
            return false;
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
        ${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.saveBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(rt.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(),et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}());
        rt.set${srfcaseformat(listcode,'l_u2lC')?cap_first}(et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}());
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
        CachedBeanCopier.copy(rt,et);
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true;
                            <#else>
        return false;
                            </#if>
                        <#else>
        return false;
                        </#if>
    }

    public void createBatch(List<${item.codeName}> list){
                    <#if item.isEnableAPIStorage()>
                            <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
        ${subSysServiceApiDECodeName?uncap_first}FeignClient.createBatch(list) ;
                            </#if>
                    </#if>
    }

                    <#elseif deaction.getCodeName()?lower_case == "update">
    @Override
    public boolean update(${item.getCodeName()} et) {
                        <#if item.isEnableAPIStorage()>
                            <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
                                <#comment>附加数据逻辑-操作前</#comment>
                                <@addBoforeLogic deaction/>
        ${item.getCodeName()} rt = ${subSysServiceApiDECodeName?uncap_first}FeignClient.update(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(),et);
        if(rt==null)
            return false;
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
        ${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.saveBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(),et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}()));
        rt.set${srfcaseformat(listcode,'l_u2lC')?cap_first}(et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}());
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
        CachedBeanCopier.copy(rt,et);
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true;
                            <#else>
        return false;
                            </#if>
                        <#else>
        return false;
                        </#if>

    }

    public void updateBatch(List<${item.codeName}> list){
                    <#if item.isEnableAPIStorage()>
                            <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
        ${subSysServiceApiDECodeName?uncap_first}FeignClient.updateBatch(list) ;
                            </#if>
                    </#if>
    }

                    <#elseif deaction.getCodeName()?lower_case == "save">
    @Override
    @Transactional
    public boolean save(${item.getCodeName()} et) {
                        <#if item.isEnableAPIStorage()>
                            <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
                                <#comment>附加数据逻辑-操作前</#comment>
                                <@addBoforeLogic deaction/>
        if(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}()==null) et.set${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}((${srfjavatype(keyfield.stdDataType)})et.getDefaultKey(true));
        if(!${subSysServiceApiDECodeName?uncap_first}FeignClient.save(et))
            return false;
		<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' &&  (MajorPSDER.getMinorPSDataEntity().getStorageMode()==1||MajorPSDER.getMinorPSDataEntity().getStorageMode()==2)>
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
                        <#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
        ${srfcaseformat(MinorEntity.getCodeName(),'l_u2lC')}Service.saveBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(),et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}());
        rt.set${srfcaseformat(listcode,'l_u2lC')?cap_first}(et.get${srfcaseformat(listcode,'l_u2lC')?cap_first}());
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true;
                            <#else>
        return false;
                            </#if>
                        <#else>
        return false;
                        </#if>
    }

    @Override
    public void saveBatch(List<${item.getCodeName()}> list) {
                        <#if item.isEnableAPIStorage()>
                            <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
        ${subSysServiceApiDECodeName?uncap_first}FeignClient.saveBatch(list) ;
                            </#if>
                        </#if>
    }

                    <#elseif deaction.getCodeName()?lower_case == "remove">
    @Override
    public boolean remove(${srfjavatype(keyfield.stdDataType)} ${keyfield.getCodeName()?lower_case}) {
                                <#if de.getMajorPSDERs()??>
                                    <#list de.getMajorPSDERs() as der>
                                        <#if der.getDERType() =='DER1N' && der.isNestedRS() && der.getMinorPSDataEntity()?? &&  (der.getMinorPSDataEntity().getStorageMode()==1||der.getMinorPSDataEntity().getStorageMode()==2) >
                                        <#assign MajorDerField = der.getPSPickupDEField()>
                                        <#assign minorKeyField = der.getMinorPSDataEntity().getKeyPSDEField()>
        ${srfcaseformat(der.getMinorPSDataEntity().getCodeName(),'l_u2lC')}Service.removeBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}(key) ;
                                        </#if>
                                    </#list>
                                </#if>
                        <#if item.isEnableAPIStorage()>
                            <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
        <#--<#comment>附加数据逻辑-操作前</#comment>-->
        <#--<@buildEntityParam deaction/>-->
        <#--<@addBoforeLogic deaction/>-->
        boolean result=${subSysServiceApiDECodeName?uncap_first}FeignClient.remove(${keyfield.getCodeName()?lower_case}) ;
        <#--<#comment>附加数据逻辑-操作后</#comment>-->
        <#--<@addAfterLogic deaction/>-->
        return result;
                            <#else>
        return false;
                            </#if>
                        <#else>
        return false;
                        </#if>
    }

    public void removeBatch(Collection<${srfjavatype(keyfield.stdDataType)}> idList){
                        <#if item.isEnableAPIStorage()>
                            <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
        ${subSysServiceApiDECodeName?uncap_first}FeignClient.removeBatch(idList);
                            </#if>
                        </#if>
    }

                    <#elseif deaction.getCodeName()?lower_case == "getdraft">
    @Override
    public ${item.getCodeName()} getDraft(${item.getCodeName()} et) {
                        <#if item.isEnableAPIStorage()>
                            <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        et=${subSysServiceApiDECodeName?uncap_first}FeignClient.getDraft();
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
                            <#else>
        return null;
                            </#if>
                        <#else>
        return null;
                        </#if>
    }

                    <#elseif deaction.getCodeName()?lower_case == "checkkey">
    @Override
    public boolean checkKey(${item.getCodeName()} et) {
                        <#if item.isEnableAPIStorage()>
                            <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
        return ${subSysServiceApiDECodeName?uncap_first}FeignClient.checkKey(et);
                            <#else>
        return false;
                            </#if>
                        <#else>
        return false;
                        </#if>
    }
                    <#else>
    @Override
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
                <#if item.isEnableAPIStorage()>
                    <#if deaction.getPSSubSysServiceAPIDEMethod()?? >
         <#comment>附加数据逻辑-操作前</#comment>
         <@addBoforeLogic deaction/>
         et=${subSysServiceApiDECodeName?uncap_first}FeignClient.${deaction.getPSSubSysServiceAPIDEMethod().getCodeName()?uncap_first}(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(),et);
         <#comment>附加数据逻辑-操作后</#comment>
         <@addAfterLogic deaction/>
         return et;
                    <#else>
         return null;
                    </#if>
                    <#else>
        return null;
                </#if>
    }
                    </#if>
                </#if>
            </#if>
        </#list>
    </#if>


    <#comment>1：N关系中，在子实体中创建父实体的实例对象</#comment>
	<#if de.getMinorPSDERs?? && de.getMinorPSDERs()??>
		<#list de.getMinorPSDERs() as MinorPSDER>
			<#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N'>
				<#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()??>
					<#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
					<#if MajorEntity.name?? && MinorPSDER.getCodeName()?? >
						<#if MinorPSDER.getPSPickupDEField?? && MinorPSDER.getPSPickupDEField()??>
							<#assign MajorkeyField = MajorEntity.getKeyPSDEField()>
							<#assign MajorField = MinorPSDER.getPSPickupDEField()>
							<#if de.getDefaultPSDEDataSet()??>
								<#assign deDefaultDataSet=de.getDefaultPSDEDataSet()>
								<#if deDefaultDataSet.getPSDEDataQueries()??>
	@Override
    public List<${item.getCodeName()}> selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case}) {
        ${item.getCodeName()}SearchContext context=new ${item.getCodeName()}SearchContext();
        context.setSize(Integer.MAX_VALUE);
        context.setN_${MajorField.name?lower_case}_eq(${MajorkeyField.codeName?lower_case});
        return ${subSysServiceApiDECodeName?uncap_first}FeignClient.search${deDefaultDataSet.getCodeName()}(context).getContent();
    }

    @Override
    public void removeBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case}) {
        Set<${srfjavatype(keyfield.stdDataType)}> delIds=new HashSet<${srfjavatype(keyfield.stdDataType)}>();
        for(${item.getCodeName()} before:selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case})){
            delIds.add(before.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
        }
        if(delIds.size()>0)
            this.removeBatch(delIds);
    }

	                                <#assign nested=MinorPSDER.isNestedRS()>
                                    <#if nested == false && MinorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                                        <#list MinorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                            <#if api.isNested()>
                                                <#assign nested=true>
                                            </#if>
                                        </#list>
                                    </#if>
                                    <#if nested>
	@Override
    public void saveBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case},List<${item.getCodeName()}> list) {
        if(list==null)
            return;
        Set<${srfjavatype(keyfield.stdDataType)}> delIds=new HashSet<${srfjavatype(keyfield.stdDataType)}>();
        List<${item.getCodeName()}> _update=new ArrayList<${item.getCodeName()}>();
        List<${item.getCodeName()}> _create=new ArrayList<${item.getCodeName()}>();
        for(${item.getCodeName()} before:selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case})){
            delIds.add(before.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
        }
        for(${item.getCodeName()} sub:list) {
            sub.set${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case});
            if(ObjectUtils.isEmpty(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}()))
                sub.set${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}((${srfjavatype(keyfield.stdDataType)})sub.getDefaultKey(true));
            if(delIds.contains(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}())) {
                delIds.remove(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0)
            this.updateBatch(_update);
        if(_create.size()>0)
            this.createBatch(_create);
        if(delIds.size()>0)
            this.removeBatch(delIds);
	}

                                    </#if>
								</#if>
							</#if>
						</#if>
					</#if>
				</#if>
			</#if>
		</#list>
	</#if>


    <#comment>输出数据查询</#comment>
    <#if item.getAllPSDEDataSets()??>
        <#list item.getAllPSDEDataSets() as dedataset>
            <#if  dedataset.getPSSubSysServiceAPIDEMethod()??>
                <#assign sysServiceApiMethod=dedataset.getPSSubSysServiceAPIDEMethod().getCodeName()?uncap_first?replace("fetch","search")>
            <#else>
                <#assign sysServiceApiMethod="search"+dedataset.getCodeName()>
            </#if>
    /**
     * 查询集合 ${dedataset.getLogicName()}
     */
    @Override
    public Page<${item.getCodeName()}> search${dedataset.getCodeName()}(${item.getCodeName()}SearchContext context) {
        <#--<#if item.isEnableNoSQLStorage() && item.getAllPSDEDBTables()??>-->
        <#--<#list item.getAllPSDEDBTables() as detable>-->
        Page<${de.getCodeName()}> ${de.getCodeName()?uncap_first}s=${subSysServiceApiDECodeName?uncap_first}FeignClient.${sysServiceApiMethod}(context);
        return ${de.getCodeName()?uncap_first}s;
        <#--</#list>-->
        <#--<#else>-->
        <#--return null ;-->
        <#--</#if>-->
    }

        </#list>
    </#if>

}

<#comment>无存储</#comment>
<#elseif de.getStorageMode()==0>

/**
 * 实体[${item.getLogicName()}] 无存储服务对象接口实现
 */
@Slf4j
@Service
public class ${item.getCodeName()}ServiceImpl implements I${de.getCodeName()}Service {

    <#assign keyfield=de.getKeyPSDEField()>

    <#comment>引入关联依赖</#comment>
    <#if de.getMajorPSDERs()??>
        <#list de.getMajorPSDERs() as der>
            <#if der.getDERType() =='DER1N' >
                <#if !P.exists('DEMinorPSDataEntity',der.getMinorPSDataEntity().getCodeName())>
    @Autowired
    @Lazy
    private ${pub.getPKGCodeName()}.core.${der.getMinorPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.service.I${der.getMinorPSDataEntity().getCodeName()}Service ${srfcaseformat(der.getMinorPSDataEntity().getCodeName(),'l_u2lC')}Service;
                </#if>
            </#if>
        </#list>
    </#if>
    <#comment>引入处理逻辑</#comment>
    <#if de.getAllPSDEActions()??>
        <#list de.getAllPSDEActions() as deAction>
            <#comment>实体行为调用处理逻辑</#comment>
            <#if deAction.getActionType() =='DELOGIC' >
            <#assign deLogic=deAction.getPSDELogic()>
                <@importDELogic deLogic />
            </#if>
            <#comment>实体行为附加逻辑</#comment>
            <#if deAction.getPSDEActionLogics()??>
                <#list deAction.getPSDEActionLogics() as deActionLogic>
                    <#assign deLogic=deActionLogic.getPSDELogic()>
                    <@importDELogic deLogic />
                </#list>
            </#if>
        </#list>
    </#if>

    <#comment>输出实体行为</#comment>
    <#if item.getAllPSDEActions()??>
        <#list item.getAllPSDEActions() as deaction>
            <#if deaction.isEnableBackend()>
                <#if deaction.getRender()??>
${deaction.getRender().code}
                <#else>
                    <#if (deaction.getActionType()=='USERCUSTOM')>
    @Override
    @Transactional
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        //自定义代码
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }

                    <#elseif deaction.getActionType()=='DELOGIC'>
    @Override
    @Transactional
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
         <#comment>附加数据逻辑-操作前</#comment>
         <@addBoforeLogic deaction/>
         ${deaction.getPSDELogic().getCodeName()?lower_case}Logic.execute(et);
         <#comment>附加数据逻辑-操作后</#comment>
         <@addAfterLogic deaction/>
         return et ;
    }

                    <#elseif deaction.getCodeName()?lower_case == 'get'>
    @Override
    public ${item.getCodeName()} get(${srfjavatype(keyfield.stdDataType)} key) {
        <#comment>附加数据逻辑-操作前</#comment>
        <@buildEntityParam deaction/>
        <@addGetActionBoforeLogic deaction/>
        ${item.getCodeName()} et = new ${item.getCodeName()}();
        et.set${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(key);
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }

                    <#elseif deaction.getCodeName()?lower_case == "createbatch">
                    <#elseif deaction.getCodeName()?lower_case == "updatebatch">
                    <#elseif deaction.getCodeName()?lower_case == "removebatch">
                    <#elseif deaction.getCodeName()?lower_case == "savebatch">
                    <#elseif deaction.getCodeName()?lower_case == "create">
    @Override
    public boolean create(${item.getCodeName()} et) {
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        //代码实现
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true;
    }

    public void createBatch(List<${item.codeName}> list){

    }

                    <#elseif deaction.getCodeName()?lower_case == "update">
    @Override
    public boolean update(${item.getCodeName()} et) {
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        //代码实现
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true;
    }

    public void updateBatch(List<${item.codeName}> list){
                    
    }

                    <#elseif deaction.getCodeName()?lower_case == "save">
    @Override
    @Transactional
    public boolean save(${item.getCodeName()} et) {
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        //代码实现
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true;
    }

    @Override
    public void saveBatch(List<${item.getCodeName()}> list) {
                       
    }

                    <#elseif deaction.getCodeName()?lower_case == "remove">
    @Override
    public boolean remove(${srfjavatype(keyfield.stdDataType)} key) {
        <#comment>附加数据逻辑-操作前</#comment>
        <@buildEntityParam deaction/>
        <@addBoforeLogic deaction/>
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return true;
    }

    public void removeBatch(Collection<${srfjavatype(keyfield.stdDataType)}> idList){
                        
    }

                    <#elseif deaction.getCodeName()?lower_case == "getdraft">
    @Override
    public ${item.getCodeName()} getDraft(${item.getCodeName()} et) {
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }

                    <#elseif deaction.getCodeName()?lower_case == "checkkey">
    @Override
    public boolean checkKey(${item.getCodeName()} et) {
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return false;
    }
                    <#else>
    @Override
    public ${item.getCodeName()} ${srfmethodname(deaction.getCodeName())}(${item.getCodeName()} et) {
        <#comment>附加数据逻辑-操作前</#comment>
        <@addBoforeLogic deaction/>
        <#comment>附加数据逻辑-操作后</#comment>
        <@addAfterLogic deaction/>
        return et;
    }
                    </#if>
                </#if>
            </#if>
        </#list>
    </#if>


    <#comment>1：N关系中，在子实体中创建父实体的实例对象</#comment>
	<#if de.getMinorPSDERs?? && de.getMinorPSDERs()??>
		<#list de.getMinorPSDERs() as MinorPSDER>
			<#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N'>
				<#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()??>
					<#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
					<#if MajorEntity.name?? && MinorPSDER.getCodeName()?? >
						<#if MinorPSDER.getPSPickupDEField?? && MinorPSDER.getPSPickupDEField()??>
							<#assign MajorkeyField = MajorEntity.getKeyPSDEField()>
							<#assign MajorField = MinorPSDER.getPSPickupDEField()>
							<#if de.getDefaultPSDEDataSet()??>
								<#assign deDefaultDataSet=de.getDefaultPSDEDataSet()>
								<#if deDefaultDataSet.getPSDEDataQueries()??>
	@Override
    public List<${item.getCodeName()}> selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case}) {
        return null;
    }

    @Override
    public void removeBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case}) {
        Set<${srfjavatype(keyfield.stdDataType)}> delIds=new HashSet<${srfjavatype(keyfield.stdDataType)}>();
        for(${item.getCodeName()} before:selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case})){
            delIds.add(before.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
        }
        if(delIds.size()>0)
            this.removeBatch(delIds);
    }

	                                <#assign nested=MinorPSDER.isNestedRS()>
                                    <#if nested == false && MinorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                                        <#list MinorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                            <#if api.isNested()>
                                                <#assign nested=true>
                                            </#if>
                                        </#list>
                                    </#if>
                                    <#if nested>
	@Override
    public void saveBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfjavatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case},List<${item.getCodeName()}> list) {
        if(list==null)
            return;
        Set<${srfjavatype(keyfield.stdDataType)}> delIds=new HashSet<${srfjavatype(keyfield.stdDataType)}>();
        List<${item.getCodeName()}> _update=new ArrayList<${item.getCodeName()}>();
        List<${item.getCodeName()}> _create=new ArrayList<${item.getCodeName()}>();
        for(${item.getCodeName()} before:selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case})){
            delIds.add(before.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
        }
        for(${item.getCodeName()} sub:list) {
            sub.set${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${MajorkeyField.codeName?lower_case});
            if(ObjectUtils.isEmpty(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}()))
                sub.set${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}((${srfjavatype(keyfield.stdDataType)})sub.getDefaultKey(true));
            if(delIds.contains(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}())) {
                delIds.remove(sub.get${srfcaseformat(keyfield.getCodeName(),'l_u2lC')?cap_first}());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0)
            this.updateBatch(_update);
        if(_create.size()>0)
            this.createBatch(_create);
        if(delIds.size()>0)
            this.removeBatch(delIds);
	}

                                    </#if>
								</#if>
							</#if>
						</#if>
					</#if>
				</#if>
			</#if>
		</#list>
	</#if>


    <#comment>输出数据查询</#comment>
    <#if item.getAllPSDEDataSets()??>
        <#list item.getAllPSDEDataSets() as dedataset>
    /**
     * 查询集合 ${dedataset.getLogicName()}
     */
    @Override
    public Page<${item.getCodeName()}> search${dedataset.getCodeName()}(${item.getCodeName()}SearchContext context) {
        <#--<#if item.isEnableNoSQLStorage() && item.getAllPSDEDBTables()??>-->
        <#--<#list item.getAllPSDEDBTables() as detable>-->
        return new PageImpl<${item.getCodeName()}>(new ArrayList(),context.getPageable(),0);
        <#--</#list>-->
        <#--<#else>-->
        <#--return null ;-->
        <#--</#if>-->
    }

        </#list>
    </#if>

}
</#if>

<#macro buildEntityParam deaction>
    <#comment>由于get跟remove参数为key，构造entity以便传入逻辑中</#comment>
    <#assign tempEntityName="et">
    <#if deaction.getPSDEActionLogics()??>
        <#list deaction.getPSDEActionLogics() as actionlogic>
            <#if actionlogic.isValid()==true>
                <#if deaction.getCodeName()?lower_case == "get">
                    <#assign tempEntityName="tempET">
                </#if>
        ${de.codeName} ${tempEntityName}=new ${de.codeName}();
                <#if keyfield??>
        ${tempEntityName}.set("${keyfield.codeName?lower_case}",key);
                </#if>
                <#break>
            </#if>
        </#list>
    </#if>
</#macro>

<#comment>Get行为附加逻辑-操作前</#comment>
<#macro addGetActionBoforeLogic deaction>
    <#if deaction.getPSDEActionLogics()??>
        <#list deaction.getPSDEActionLogics() as actionlogic>
            <#if actionlogic.getAttachMode()=='BEFORE' && actionlogic.isValid()==true>
                <#if actionlogic.isInternalLogic()>
        ${actionlogic.getPSDELogic().getCodeName()?lower_case}Logic.execute(tempET);
                </#if>
            </#if>
        </#list>
    </#if>
</#macro>

<#comment>附加逻辑-操作前</#comment>
<#macro addBoforeLogic deaction>
    <#if deaction.getPSDEActionLogics()??>
        <#list deaction.getPSDEActionLogics() as actionlogic>
            <#if actionlogic.getAttachMode()=='BEFORE' && actionlogic.isValid()==true>
                <#if actionlogic.isInternalLogic()>
        ${actionlogic.getPSDELogic().getCodeName()?lower_case}Logic.execute(et);
                </#if>
            </#if>
        </#list>
    </#if>
</#macro>

<#comment>附加逻辑-操作后</#comment>
<#macro addAfterLogic deaction>
    <#if deaction.getPSDEActionLogics()??>
        <#list deaction.getPSDEActionLogics() as actionlogic>
            <#if actionlogic.getAttachMode()=='AFTER' && actionlogic.isValid()==true>
                <#if actionlogic.isInternalLogic()>
        ${actionlogic.getPSDELogic().getCodeName()?lower_case}Logic.execute(et);
                </#if>
            </#if>
        </#list>
    </#if>
</#macro>
<#macro importDELogic deLogic>
    <#if !P.exists('DELOGIC',deLogic.getCodeName())>

    @Autowired
    @Lazy
    private ${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.service.logic.I${de.getCodeName()}${deLogic.codeName}Logic ${deLogic.getCodeName()?lower_case}Logic;
    </#if>
</#macro>
</#if>
